/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class ChemixerRecipe
extends MekanismRecipe
implements TriPredicate<ItemStack, ItemStack, GasStack> {
    private final ItemStackIngredient inputMain;
    private final ItemStackIngredient inputExtra;
    private final ChemicalStackIngredient.GasStackIngredient inputGas;
    private final ItemStack outputItem;

    public ChemixerRecipe(ResourceLocation id, ItemStackIngredient inputMain, ItemStackIngredient inputExtra, ChemicalStackIngredient.GasStackIngredient inputGas, ItemStack outputItem) {
        super(id);
        this.inputMain = Objects.requireNonNull(inputMain, "Item input cannot be null.");
        this.inputExtra = Objects.requireNonNull(inputExtra, "Extra input cannot be null.");
        this.inputGas = Objects.requireNonNull(inputGas, "Gas input cannot be null.");
        Objects.requireNonNull(outputItem, "Item output cannot be null.");
        this.outputItem = outputItem.m_41777_();
    }

    public ItemStackIngredient getInputMain() {
        return this.inputMain;
    }

    public ItemStackIngredient getInputExtra() {
        return this.inputExtra;
    }

    public ChemicalStackIngredient.GasStackIngredient getInputGas() {
        return this.inputGas;
    }

    public boolean test(ItemStack solid, ItemStack extra, GasStack gas) {
        return this.inputMain.test((Object)solid) && this.inputExtra.test((Object)extra) && this.inputGas.test((Object)gas);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public ItemStack getOutput(@NotNull ItemStack input, @NotNull ItemStack extra, @NotNull GasStack gas) {
        return this.outputItem.m_41777_();
    }

    public boolean m_142505_() {
        return this.inputMain.hasNoMatchingInstances() || this.inputExtra.hasNoMatchingInstances() || this.inputGas.hasNoMatchingInstances();
    }

    public void write(FriendlyByteBuf buffer) {
        this.inputMain.write(buffer);
        this.inputExtra.write(buffer);
        this.inputGas.write(buffer);
        buffer.m_130055_(this.outputItem);
    }

    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.outputItem);
    }
}

